# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 1
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR1_strategy.txt
# LLM Suggested Fallback: Not Provided

def friendly_neighbor(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    total_rounds = len(my_history) + 1
    last_opp_move = opp_history[-1]
    
    # Analyze opponent's code for simple patterns
    always_c = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code
    always_d = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code
    
    if always_c:
        return "D" if total_rounds > 5 else "C"
    if always_d:
        return "D"
    
    # Tit-for-Tat with forgiveness
    if total_rounds <= 8:
        if last_opp_move == "C":
            return "C" if random.random() < 0.9 else "D"
        else:
            return "D" if random.random() < 0.9 else "C"
    else:
        # Final rounds strategy
        opp_defects = opp_history.count("D")
        if opp_defects > len(opp_history) * 0.2:
            return "D"
        else:
            return "C"